package presentation.graph;

/**
 * @author Alberto Iachini
 */

import org.jgraph.graph.VertexRenderer;
import org.jgraph.graph.VertexView;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.BasicStroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class FinalStateVertexRenderer extends VertexRenderer {
	
	private static final long serialVersionUID = -8251096058938250432L;

	public FinalStateVertexRenderer()
	{
		super();
	}
	
	public void paint(Graphics g)
	{
		try {
			if (gradientColor != null && !preview && isOpaque()) {
				setOpaque(false);
				Graphics2D g2d = (Graphics2D) g;
				//g2d.setPaint(new GradientPaint(0, 0, getBackground(),getWidth(), getHeight(), gradientColor, true));
				g2d.setPaint(gradientColor);
				g2d.setStroke(new BasicStroke(3.0f));
				g2d.drawOval(3, 3, getWidth()-6, getHeight()-6);
				g2d.drawOval(7, 7, getWidth()-14, getHeight()-14);
			}
			super.paint(g);
			paintSelectionBorder(g);
		} catch (IllegalArgumentException e) {
			// JDK Bug: Zero length string passed to TextLayout constructor
		}
	}
	
	public Point2D getPerimeterPoint(VertexView view, Point2D source, Point2D p) {
		Rectangle2D bounds = view.getBounds();
		double x = bounds.getX();
		double y = bounds.getY();
		double width = bounds.getWidth();
		double height = bounds.getHeight();
		
		double a = width / 2;
		double b = height / 2;
		
		double xCenter = x + a;
		double yCenter = y + b;
		
		double dx = p.getX() - xCenter; // Compute Angle
		double dy = p.getY() - yCenter;
		
		double alpha = Math.atan2(dy, dx);
		
		double xout = (a*Math.cos(alpha)) + xCenter;
		double yout = (b*Math.sin(alpha)) + yCenter;
		
		return new Point2D.Double(xout, yout);
	}

}
